implementation module ExtString;

import StdArray, StdInt, StdString;
from StdClass import inc, dec;
from StdMisc import abort;
//1.3
from StdChar import ==;
//3.1
/*2.0
from StdChar import class ==;
0.2*/
from StdBool import ||;

(CHAR) string i :== string.[i];

(BYTE) :: !String !Int -> Int;
(BYTE) string i = toInt (string.[i]);

u_char_array_slice :: !*{#Char} !Int !Int -> (!*{#Char},!*{#Char});
u_char_array_slice array begin_index end_index = code {
		push_a 0
	.d 1 2 ii
		jsr	sliceAC
	.o 1 0 
};

CharIndex  :: !String !Int !Char -> (!Bool,!Int); 
CharIndex s i char
	| i == (size s)
		= (False,size s);
		
		| i < (size s)
			| s.[i] == char
				= (True,i);
				= CharIndex s (inc i) char;
			= abort "CharIndex: index out of range";
			
CharIndexFunc  :: !String !Int (Char -> Bool) -> (!Bool,!Int); 
CharIndexFunc s i f
	| i < 0 || (i == (size s))
		= (False,size s);
		
		| i < (size s)
			| f s.[i]
				= (True,i);
				= CharIndexFunc s (inc i) f;
			= abort "CharIndexFunc: index out of range";

			
ends :: !String !String -> Bool;
	ends s postfix
		#! s_length
			= size s;
		#! postfix_length 
			= size postfix; 
		= (s % (s_length-postfix_length, s_length-1)) == postfix;
		
CharIndexBackwards :: !String !Int !Char -> (!Bool,!Int);
CharIndexBackwards s i char
	| i == (-1)
		= (False,size s);
		
		| s.[i] == char
			= (True,i);
			= CharIndexBackwards s (dec i) char;
			
starts :: !String !String -> (!Bool,!Int);
starts prefix s
	| l_s < l_prefix 
		= (False,10);
		
		// s has at least size of prefix
		| (s % (0, l_prefix - 1)) == prefix
			= (True,l_prefix);
			= (False,11);
where
{
	l_prefix 
		= size prefix;
	l_s
		= size s;
}

starts_at :: !String !String !Int -> (!Bool,!Int);
starts_at prefix s index
	| l_s < l_prefix 
		= (False,10);
		
		// s has at least size of prefix
		| (s % (index, l_prefix - 1)) == prefix
			= (True,l_prefix);
			= (False,11);
where
{
	l_prefix 
		= size prefix;
	l_s
		= (index + size s);
}

import StdList;

ExtractArguments :: !Char !Int !String [String] -> [String];
ExtractArguments sep i request args
	| size request == i
		= args;
		| (request.[i]) == sep
			= args;
		
			#! (found, index)
				= CharIndex request i sep;
			| found
				= ExtractArguments sep (inc index) request (args ++ [request % (i,index-1)]);
				= abort ("ExtractArguments: separator not found:" +++ request);






